#!usr/bin/.env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@time: 2021/03/26
@file: middlewares.py
@function:
@modify:
"""
import logging
from flask import g, request, url_for, current_app, make_response, jsonify

from config.wechat_config import platform_config_list
from service.agent_service import AgentService
from utils.error_code.auth_error import TOKEN_NOT_VALID_ERROR, TOKEN_EXPIRE_ERROR
from models.user_models import CustomerModel, AgentAccount
from utils.my_response import BaseResponse
from utils.jwt_util import verify_jwt

logger = logging.getLogger(__name__)


def log_enter_interface():
    """
    日志打印进入接口
    :return:
    """
    logger.info("#########################   进入 {} 接口 ################################ ".format(request.path))


def log_out_interface(environ):
    """
    日志打印退出接口
    :return:
    """
    logger.info("#########################   退出 {} 接口 ################################\n".format(request.path))
    return environ


def close_db_session(environ):
    from models.base_model import db
    db.session.close()
    return environ


"""用户认证机制==>每次请求前获取并校验token"""

"@myapps.before_request 不使@调用装饰器 在 init文件直接装饰"


def jwt_authentication():
    """
    1.获取请求头Authorization中的token
    2.判断是否以 Bearer开头
    3.使用jwt模块进行校验
    4.判断校验结果,成功就提取token中的载荷信息,赋值给g对象保存
    """
    if current_app.name == "nfc_socket":
        NO_AUTH_CHECK_URL = [url_for('account.login'), ]
    else:
        NO_AUTH_CHECK_URL = []

    if request.path not in NO_AUTH_CHECK_URL:
        token = request.headers.get('Authorization')
        # "校验token"
        payload = verify_jwt(token)
        # "判断token的校验结果"
        if payload:
            # "获取载荷中的信息赋值给g对象"
            user_id = payload.get('user_id')
            if not user_id:
                return BaseResponse(**TOKEN_NOT_VALID_ERROR)
            g.user = CustomerModel.query.filter_by(id=user_id).first()
        else:
            return BaseResponse(**TOKEN_NOT_VALID_ERROR)


def get_platform():
    """

    :return:
    """

    platform = request.headers.get('platform', "xiaotu")
    g.platform = platform_config_list.index(platform)


def all_options_pass():
    """

    :return:
    """
    if request.method == "OPTIONS":
        headers = {'Access-Control-Allow-Origin': '*',
                   'Access-Control-Allow-Methods': 'POST',
                   'Access-Control-Allow-Headers':
                       'Content-Type, Content-Length, Authorization, Accept, X-Requested-With , platform',
                   }

        return make_response((jsonify({'error_code': 0}), 200, headers))
