#! /usr/bin/.env python
from __future__ import print_function
from smartcard.scard import *
import smartcard.util


class ScardService(object):

    def __init__(self):
        self.reader = "ACS ACR1281 1S Dual Reader PICC 0"

    def printstate(self, state):
        reader, eventstate, atr = state
        print(reader + " " + smartcard.util.toHexString(atr, smartcard.util.HEX))
        if eventstate & SCARD_STATE_ATRMATCH:
            print('\tCard found')
        if eventstate & SCARD_STATE_UNAWARE:
            print('\tState unware')
        if eventstate & SCARD_STATE_IGNORE:
            print('\tIgnore reader')
        if eventstate & SCARD_STATE_UNAVAILABLE:
            print('\tReader unavailable')
        if eventstate & SCARD_STATE_EMPTY:
            print('\tReader empty')
            return -1
        if eventstate & SCARD_STATE_PRESENT:
            print('\tCard present in reader')
            return 1
        if eventstate & SCARD_STATE_EXCLUSIVE:
            print('\tCard allocated for exclusive use by another application')
        if eventstate & SCARD_STATE_INUSE:
            print('\tCard in used by another application but can be shared')
        if eventstate & SCARD_STATE_MUTE:
            print('\tCard is mute')
        if eventstate & SCARD_STATE_CHANGED:
            print('\tState changed')
        if eventstate & SCARD_STATE_UNKNOWN:
            print('\tState unknowned')
        return False

    def my_scard_handler(self):
        try:
            hresult, hcontext = SCardEstablishContext(SCARD_SCOPE_USER)
            if hresult != SCARD_S_SUCCESS:
                raise error(
                    'Failed to establish context: ' + SCardGetErrorMessage(hresult))
            print('Context established!')

            try:
                # 获取读卡器列表，筛选PICC类型是否存在
                hresult, readers = SCardListReaders(hcontext, [])
                if hresult != SCARD_S_SUCCESS:
                    raise error(
                        'Failed to list readers: ' + SCardGetErrorMessage(hresult))
                if self.reader not in readers:
                    raise error('can not find reader ==> ' + self.reader)

                readerstates = [(self.reader, SCARD_STATE_UNAWARE)]
                # for i in range(len(readers)):
                #     readerstates += [(readers[i], SCARD_STATE_UNAWARE)]

                # print('----- Current reader and card states are: -------')
                # hresult, newstates = SCardGetStatusChange(hcontext, INFINITE, readerstates)
                # for i in newstates:
                #     self.printstate(i)
                #
                # print('----- Please insert or remove a card ------------')
                # hresult, newstates = SCardGetStatusChange(
                #     hcontext,
                #     INFINITE,
                #     newstates)
                #
                # print('----- New reader and card states are: -----------')
                # for i in newstates:
                #     self.printstate(i)

                print('----- Please insert or remove a card ------------')
                newstates = readerstates
                while True:
                    hresult, newstates = SCardGetStatusChange(hcontext, INFINITE, newstates)
                    result = self.printstate(newstates[0])
                    if result == -1:
                        print("请放入设备")
                        continue
                    elif result == 1:
                        card_transmit(hcontext, self.reader)
                    else:
                        print("未知错位，请重试")
                        exit(1)


            finally:
                hresult = SCardReleaseContext(hcontext)
                if hresult != SCARD_S_SUCCESS:
                    raise error(
                        'Failed to release context: ' + \
                        SCardGetErrorMessage(hresult))
                print('Released context.')

        except error as e:
            print(e)


def card_transmit(hcontext, zreader):
    SELECT = [0xFF, 0xB0, 0x00]
    DF_TELECOM = [0x10, 0x10]
    GET_RESPONSE = [0xA0, 0xC0, 0x00, 0x00]
    print('Trying to select DF_TELECOM of card in', zreader)

    try:
        hresult, hcard, dwActiveProtocol = SCardConnect(
            hcontext,
            zreader,
            SCARD_SHARE_SHARED, SCARD_PROTOCOL_T0 | SCARD_PROTOCOL_T1)
        if hresult != SCARD_S_SUCCESS:
            raise error(
                'Unable to connect: ' +
                SCardGetErrorMessage(hresult))
        print('Connected with active protocol', dwActiveProtocol)

        try:
            hresult, response = SCardTransmit(
                hcard, dwActiveProtocol, SELECT + DF_TELECOM)
            if hresult != SCARD_S_SUCCESS:
                raise error(
                    'Failed to transmit: ' +
                    SCardGetErrorMessage(hresult))
            print('Selected DF_TELECOM: ' +
                  smartcard.util.toHexString(
                      response, smartcard.util.HEX))
            # hresult, response = SCardTransmit(
            #     hcard,
            #     dwActiveProtocol,
            #     GET_RESPONSE + [response[1]])
            # if hresult != SCARD_S_SUCCESS:
            #     raise error(
            #         'Failed to transmit: ' +
            #         SCardGetErrorMessage(hresult))
            # print('GET_RESPONSE after SELECT DF_TELECOM: ' +
            #       smartcard.util.toHexString(
            #           response, smartcard.util.HEX))
        finally:
            hresult = SCardDisconnect(hcard, SCARD_UNPOWER_CARD)
            if hresult != SCARD_S_SUCCESS:
                raise error(
                    'Failed to disconnect: ' +
                    SCardGetErrorMessage(hresult))
            print('Disconnected')

    except error as message:
        print(error, message)


if __name__ == '__main__':
    service = ScardService()
    service.my_scard_handler()
