# -*- coding: utf-8 -*-
from flask_sqlalchemy import SQLAlchemy
from sqlalchemy import Column, func

db = SQLAlchemy(session_options={"autoflush": False})


class BaseModel(db.Model):
    __abstract__ = True

    created_at = Column(db.TIMESTAMP, nullable=False, server_default=func.now())
    updated_at = Column(db.TIMESTAMP, nullable=False, server_default=func.now(), onupdate=func.now())
