!usr/bin/.env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@file: wechat_config.py
"""
import os

XT_CONFIG = {
    "app_id": os.getenv("XT_MINI_PROGRAM_APPID"),
    "app_secret": os.getenv("XT_MINI_PROGRAM_APPSECRET"),
}
XDY_MINI_PROGRAM_CONFIG = {
    "app_id": os.getenv("XDY_MINI_PROGRAM_APPID"),
    "app_secret": os.getenv("XDY_MINI_PROGRAM_APPSECRET"),
}

SXXJ_MINI_PROGRAM_CONFIG = {
    "app_id": os.getenv("SXXJ_MINI_PROGRAM_APPID"),
    "app_secret": os.getenv("SXXJ_MINI_PROGRAM_APPSECRET"),
}
SJY_CONFIG = {
    "app_id": os.getenv("SJY_MINI_PROGRAM_APPID"),
    "app_secret": os.getenv("SJY_MINI_PROGRAM_APPSECRET"),
}

SSW_PAY_CONFIG = {
    "mch_id": os.getenv("SSW_MCHID"),
    "pay_key": os.getenv("SSW_PAY_KEY"),
    "cert_path": os.getenv("SSW_PAY_SSL_CERT_PATH"),
    "key_path": os.getenv("SSW_PAY_SSL_KEY_PATH"),
    'callback_url': '/rent/wx_pay_callback',
    'refund_callback_url': '/rent/refund_callback',
    'domain': 'https://guide.ssw-htzn.com/v2/tour/'
}

HTZN_OA_CONFIG = {
    "app_id": os.getenv("HTZN_OA_APPID"),
    "app_secret": os.getenv("HTZN_OA_APPSECRET"),
    "Token": os.getenv("HTZN_OA_TOKEN"),
    "EncodingAESKey": os.getenv("HTZN_OA_AESKEY"),
    "oa_id": os.getenv("HTZN_OA_ID")
}

XJWL_OA_CONFIG = {
    "app_id": os.getenv("XJWL_OA_APPID"),
    "app_secret": os.getenv("XJWL_OA_APPSECRET"),
    "Token": os.getenv("XJWL_OA_TOKEN"),
    "EncodingAESKey": os.getenv("XJWL_OA_AESKEY"),
    "oa_id": os.getenv("XJWL_OA_ID")
}

XJWL_PAY_CONFIG = {
    "mch_id": os.getenv("XJWL_MCHID"),
    "pay_key": os.getenv("XJWL_PAY_KEY"),
    "cert_path": os.getenv("XJWL_PAY_SSL_CERT_PATH"),
    "key_path": os.getenv("XJWL_PAY_SSL_KEY_PATH"),
    'callback_url': '/rent/wx_pay_callback',
    'refund_callback_url': '/rent/refund_callback',
    'domain': 'https://guide.ssw-htzn.com/v2/tour/'
}

SXXJ_OA_CONFIG = {
    "app_id": os.getenv("SXXJ_OA_APPID"),
    "app_secret": os.getenv("SXXJ_OA_APPSECRET"),
    "Token": os.getenv("SXXJ_OA_TOKEN"),
    "EncodingAESKey": os.getenv("SXXJ_OA_AESKEY"),
    "oa_id": os.getenv("SXXJ_OA_ID")
}

pay_config_list = ["", "ssw", "xjwl"]

pay_config_dict = {
    "ssw": SSW_PAY_CONFIG,
    "xjwl": XJWL_PAY_CONFIG,
}

platform_config_list = ["", "xiaotu", "xiaodaoyou", "huituzhineng", "xiaojian", "shoujiyou", "sxxj_mp", "sxxj_oa",
                        "business_web"]
platform_config_dict = {
    "xiaotu": XT_CONFIG,
    "xiaodaoyou": XDY_MINI_PROGRAM_CONFIG,
    "huituzhineng": HTZN_OA_CONFIG,
    "xiaojian": XJWL_OA_CONFIG,
    "shoujiyou": SJY_CONFIG,
    "sxxj_mp": SXXJ_MINI_PROGRAM_CONFIG,
    "sxxj_oa": SXXJ_OA_CONFIG,
    "business_web": "business_web",
}

platform_appid_config_list = [
    "",
    XT_CONFIG["app_id"],  # 晓兔小程序 平台序号 ==>1
    XDY_MINI_PROGRAM_CONFIG["app_id"],  # 小导游小程序  平台序号==>2
    HTZN_OA_CONFIG["app_id"],  # 灰兔智能公众号  平台序号==>3
    XJWL_OA_CONFIG["app_id"],  # 晓见文旅公众号 平台序号==> 4
    SJY_CONFIG["app_id"],  # 手机游小程序 平台序号==> 5
    SXXJ_MINI_PROGRAM_CONFIG["app_id"],  # 随心晓见小程序 平台序号==> 6
    SXXJ_OA_CONFIG["app_id"],  # 随心晓见公众号 平台序号==> 7
    "business_web"  # 商户PC平台 平台序号==> 8
]

platform_appid_config_dict = {
    "xiaotu": XT_CONFIG["app_id"],
    "xiaodaoyou": XDY_MINI_PROGRAM_CONFIG["app_id"],
    "huituzhineng": HTZN_OA_CONFIG["app_id"],
    "xiaojian": XJWL_OA_CONFIG["app_id"],
    "shoujiyou": SJY_CONFIG["app_id"],
    "sxxj_mp": SXXJ_MINI_PROGRAM_CONFIG["app_id"],
    "sxxj_oa": SXXJ_OA_CONFIG["app_id"],
    "business_web": "business_web"
}

oa_id_config = {
    "gh_598e6bc39f09": HTZN_OA_CONFIG,
    "gh_c3bea8443020": XJWL_OA_CONFIG,
    "gh_b2a7d67e5686": SXXJ_OA_CONFIG,
}

oa_id_mini_program_dict = {
    "gh_598e6bc39f09": "",
    "gh_c3bea8443020": {"app_id": SJY_CONFIG["app_id"],
                        "thumb_media_id": "U0xslX7PT0MqDF6nvztA98zjPFNOx67c2TC4xelRNa4"},
    "gh_b2a7d67e5686": {"app_id": SXXJ_MINI_PROGRAM_CONFIG["app_id"],
                        "thumb_media_id": "HJKoAr6Q8QIr90A8eifiXdjAg93KUlhFh8vpfjJqzT0"},
}

# 拙政园,留园的机柜从随心晓见公众号跳转的时候跳转到晓兔小程序
SXXJ_OA_TO_XT_MINI_PROGRAM_MAC_LIST = ["2004013201020005", "2004013201020006", "2004013201020008", "1909033201020171",
                                       "1909033201020172", "1909033201020173", "1909033201020174", "1909033201020175",
                                       "2004013201020007"
                                       ]
