#!usr/bin/.env python
# -*- coding:utf-8 _*-
"""
@version:
@author:Aeolus
@file: __init__.py
@function:
@modify:
"""
from flask import Flask
from flask_cors import CORS
from flask_log_request_id import RequestID
from dotenv import load_dotenv

from models.base_model import db
from utils.my_redis_cache import redis_client
from utils.mylogger import set_logger


def create_app(config_name):
    from config.env_path_config import env_path
    load_dotenv(dotenv_path=env_path, verbose=True, override=True)
    set_logger()

    app = Flask("repair_tool")
    from config.app_config import config
    app.config.from_object(config[config_name])
    CORS(app)
    RequestID(app)

    return app
