#! /usr/bin/.env python
from __future__ import print_function
from smartcard.scard import *
import smartcard.util

srTreeATR = [0x3B, 0x77, 0x94, 0x00, 0x00, 0x82, 0x30, 0x00, 0x13, 0x6C, 0x9F, 0x22]
srTreeMask = [0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF]


class ScardService(object):

    def __init__(self):
        self.reader = "ACS ACR1281 1S Dual Reader PICC 0"

    def printstate(self, state):
        reader, eventstate, atr = state
        print(reader + " " + smartcard.util.toHexString(atr, smartcard.util.HEX))
        if eventstate & SCARD_STATE_ATRMATCH:
            print('\tCard found')
        if eventstate & SCARD_STATE_UNAWARE:
            print('\tState unware')
        if eventstate & SCARD_STATE_IGNORE:
            print('\tIgnore reader')
        if eventstate & SCARD_STATE_UNAVAILABLE:
            print('\tReader unavailable')
        if eventstate & SCARD_STATE_EMPTY:
            print('\tReader empty')
        if eventstate & SCARD_STATE_PRESENT:
            print('\tCard present in reader')
            return True
        if eventstate & SCARD_STATE_EXCLUSIVE:
            print('\tCard allocated for exclusive use by another application')
        if eventstate & SCARD_STATE_INUSE:
            print('\tCard in used by another application but can be shared')
        if eventstate & SCARD_STATE_MUTE:
            print('\tCard is mute')
        if eventstate & SCARD_STATE_CHANGED:
            print('\tState changed')
        if eventstate & SCARD_STATE_UNKNOWN:
            print('\tState unknowned')
        return False

    def my_scard_handler(self):
        try:
            hresult, hcontext = SCardEstablishContext(SCARD_SCOPE_USER)
            if hresult != SCARD_S_SUCCESS:
                raise error(
                    'Failed to establish context: ' + SCardGetErrorMessage(hresult))
            print('Context established!')

            try:
                hresult, readers = SCardListReaders(hcontext, [])
                if hresult != SCARD_S_SUCCESS:
                    raise error(
                        'Failed to list readers: ' + SCardGetErrorMessage(hresult))
                if self.reader not in readers:
                    raise error('can not find reader ==> ' + self.reader)

                readerstates = [(self.reader, SCARD_STATE_UNAWARE)]
                # for i in range(len(readers)):
                #     readerstates += [(readers[i], SCARD_STATE_UNAWARE)]

                print('----- Current reader and card states are: -------')
                hresult, newstates = SCardGetStatusChange(hcontext, 0, readerstates)
                for i in newstates:
                    self.printstate(i)

                print('----- Please insert or remove a card ------------')
                hresult, newstates = SCardGetStatusChange(
                    hcontext,
                    INFINITE,
                    newstates)

                print('----- New reader and card states are: -----------')
                for i in newstates:
                    self.printstate(i)

            finally:
                hresult = SCardReleaseContext(hcontext)
                if hresult != SCARD_S_SUCCESS:
                    raise error(
                        'Failed to release context: ' + \
                        SCardGetErrorMessage(hresult))
                print('Released context.')

        except error as e:
            print(e)


if __name__ == '__main__':
    service = ScardService()
    service.my_scard_handler()
