# -*- coding: utf-8 -*-
import datetime
import logging
import time

from flask import Blueprint, jsonify, request, g

from config.commen_config import LOGIN_TYPE
from models.base_model import db
from models.user_models import NfcAccountModel, NfcAccountLogRecord
from service.sms_service import SMSService
from utils.error_code.auth_error import PHONE_NOT_NULL_ERROR, PHONE_NOT_VALID_ERROR, TOKEN_EXPIRE_ERROR, \
    TOKEN_NOT_VALID_ERROR, VERIFICATION_CODE_INVALID_ERROR, VERIFICATION_CODE_ERROR
from utils.jwt_util import verify_jwt, generate_jwt
from utils.my_response import BaseResponse

logger = logging.getLogger(__name__)

account = Blueprint('account', __name__)


@account.route('/sendCode', methods=['GET', 'POST'])
def send_code():
    json_data = request.get_json()
    cur_ip = request.remote_addr
    phone = json_data['phone'] if 'phone' in json_data else None

    if not phone:
        return BaseResponse(**PHONE_NOT_NULL_ERROR)

    logger.info(phone)
    # 判断该手机号是否再数据库中，不在返回无权限登录
    account = NfcAccountModel.query.filter_by(phone=phone, status=1).first()
    if not account:
        return BaseResponse(**PHONE_NOT_VALID_ERROR)

    sms = SMSService()
    result = sms.phoneSendCode(phone, 520391, '灰兔智能')
    logger.info(result)

    agent_log = NfcAccountLogRecord()
    agent_log.phone = phone
    agent_log.ip = cur_ip
    agent_log.last_login = datetime.datetime.now()
    agent_log.login_type = LOGIN_TYPE['send_code']
    agent_log.created_at = datetime.datetime.now()
    agent_log.updated_at = datetime.datetime.now()
    db.session.add(agent_log)
    db.session.commit()

    return BaseResponse()


@account.route('/login', methods=['GET', 'POST'])
def login():
    token = request.headers.get('token')
    cur_ip = request.remote_addr
    json_data = request.get_json()

    data = {}
    phone = json_data['phone'] if 'phone' in json_data else None
    code = json_data['code'] if 'code' in json_data else None
    login_type = json_data['type'] if 'type' in json_data else 1  # 1.验证码登录，2.密码登录

    if token:
        # token登录
        payload = verify_jwt(token)
        # "判断token的校验结果"
        if not payload:
            return BaseResponse(**TOKEN_NOT_VALID_ERROR)
        else:
            # "获取载荷中的信息赋值给g对象"
            user_id = payload.get('user_id')
            if not user_id:
                return BaseResponse(**TOKEN_NOT_VALID_ERROR)
            user_info = NfcAccountModel.query.filter_by(id=user_id, status=1).first()
            if not user_info:
                return BaseResponse(**TOKEN_NOT_VALID_ERROR)
    else:
        if login_type == 1:
            # 验证码登录
            # 判断验证码是否正确
            sms = SMSService()
            res = sms.verificate(phone, code)
            if res == -1:
                return BaseResponse(**VERIFICATION_CODE_INVALID_ERROR)
            elif res == -2:
                return BaseResponse(**VERIFICATION_CODE_ERROR)

            user_info = NfcAccountModel.query.filter_by(phone=phone, status=1).first()
            if not user_info:
                return BaseResponse(**PHONE_NOT_VALID_ERROR)

    new_token = generate_jwt(payload={"user_id": user_info.id}, expiry=time.time() + 24 * 60 * 60)
    user_info.access_token = new_token
    db.session.add(user_info)

    agent_log = NfcAccountLogRecord()
    agent_log.phone = user_info.phone
    agent_log.ip = cur_ip
    agent_log.last_login = user_info.last_login
    agent_log.login_type = LOGIN_TYPE['token_login']
    agent_log.created_at = datetime.datetime.now()
    agent_log.updated_at = datetime.datetime.now()
    db.session.add(agent_log)
    db.session.commit()

    data['token'] = new_token
    data['user_name'] = user_info.user_name
    data['phone'] = user_info.phone
    return BaseResponse(data=data)


@account.route('/test', methods=['GET', 'POST'])
def my_test():
    return BaseResponse()
