from flask import Flask, render_template
from flask_socketio import SocketIO, emit

app = Flask(__name__)
app.config['SECRET_KEY'] = 'secret!'
async_mode = 'eventlet'
socketio = SocketIO(app, cors_allowed_origins="*", logger=True, engineio_logger=True)


@app.route('/')
def index():
    return render_template('index.html')


# @socketio.event
# def my_event(message):
#     print("==================")
#     emit('my response', {'data': 'got it!'})

@socketio.on('mymessage', namespace='/test')
def handle_message(data):
    print('30 received message: ')
    print(data)
    result = emit('my_response', {'code': '200', 'msg': 'start to process...'}, namespace='/test')
    print(result)


@socketio.on('connect',  namespace='/test')
def handle_connect(data):
    print('30 received connect: ')
    print(data)
    result = emit('my_response', {'code': '200', 'msg': 'start to process...'}, namespace='/test')
    print(result)


if __name__ == '__main__':
    socketio.run(app)
