import logging

from flask_log_request_id import RequestIDLogFilter


def set_logger():
    console_handler = logging.StreamHandler()
    console_handler.setLevel(logging.DEBUG)
    console_handler.setFormatter(
        logging.Formatter(
            "%(asctime)s - %(filename)s - %(funcName)s -[line:%(lineno)d] - %(levelname)s - request_id=%(request_id)s: %(message)s",
            "%Y-%m-%d %H:%M:%S"))
    console_handler.addFilter(RequestIDLogFilter())
    logging.getLogger().setLevel(logging.DEBUG)
    logging.getLogger().addHandler(console_handler)
