#!usr/bin/env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@time: 2021/03/26
@file: __init__.py.py
@function:
@modify:
"""
import logging

from flask import Flask
from flask_log_request_id import RequestID
from flask_sqlalchemy import SQLAlchemy

from config import config
from mylogger import MyLogger
from utils import jwt_authentication

db = SQLAlchemy()


def create_app(config_name):
    print(config_name)
    app = Flask(__name__)
    app.config.from_object(config[config_name])
    db.init_app(app)

    RequestID(app)
    MyLogger()
    # app.before_request(jwt_authentication)
    # todo register blueprint
    from app.api import api
    from app.api.repair import repair
    app.register_blueprint(api, url_prefix='/api')
    app.register_blueprint(repair, url_prefix='/api/repair')
    return app
