#!usr/bin/env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@time: 2021/04/27
@file: repair.py
@function:
@modify:
"""
import logging

from flask import Blueprint, request

from app import db
from models.Repairs import PowerRepairModel
from utils.return_code import BASE_RESPONSE, PARAMS_INVALID, DUPLICATE_RECORD, SQL_ERROR

logger = logging.getLogger(__name__)
repair = Blueprint('repair', __name__)


@repair.route("/update", methods=["POST"])
def update_repair():
    nfc_id = request.values.get("nfc_id", None)
    power_sn = request.values.get("sn", None)
    repair_content = request.values.get("repair_content", None)
    repair_man = request.values.get("repair_man", None)
    index = request.values.get("index", None)

    if not nfc_id or not power_sn or not repair_content or not repair_man or int(index) > 5:
        return BASE_RESPONSE(**PARAMS_INVALID)
    logger.info('=======================')
    result = PowerRepairModel.query.filter_by(power_sn=power_sn, index=index).first()
    if result:
        return BASE_RESPONSE(**DUPLICATE_RECORD)

    model = PowerRepairModel()
    model.power_sn = power_sn
    model.nfc_id = nfc_id
    model.repair_content = repair_content
    model.repair_man = repair_man
    model.index = index
    try:
        db.session.add(model)
        db.session.commit()
    except Exception as e:
        logger.info(e)
        return BASE_RESPONSE(**SQL_ERROR)

    return BASE_RESPONSE()


@repair.route("/list", methods=["POST"])
def list_repair():
    power_sn = request.values.get("sn", None)

    if not power_sn:
        return BASE_RESPONSE(**PARAMS_INVALID)
    logger.info('=======================')
    return_data = []
    result = PowerRepairModel.query.filter_by(power_sn=power_sn).order_by(PowerRepairModel.index.asc()).all()
    if result:
        for i in result:
            return_data.append({"sn": i.power_sn,
                                "nfc_id": i.nfc_id,
                                "repair_content": i.repair_content,
                                "repair_man": i.repair_man,
                                "index": i.index,
                                })
    else:
        return_data = []

    return BASE_RESPONSE(data=return_data)
