#!usr/bin/env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@time: 2021/03/25
@file: app.py.py
@function:
@modify:
"""

import os

from flask import copy_current_request_context

basedir = os.path.abspath(os.path.dirname(__file__))


class Config:
    SECRET_KEY = os.environ.get('SECRET_KEY');
    SQLALCHEMY_TRACK_MODIFICATIONS = False
    SQLALCHEMY_RECORD_QUERIES = True
    SQLALCHEMY_POOL_SIZE = 10
    SQLALCHEMY_POOL_RECYCLE = 1800

    @staticmethod
    def init_app(app):
        pass


class DevelopmentConfig(Config):
    DEBUG = True
    SQLALCHEMY_DATABASE_URI = 'mysql+pymysql://root:N58uTiMT#tt*@sh-cdb-9yr5zhu0.sql.tencentcdb.com:61088/suishenwan'


class ProductionConfig(Config):
    print("here is ProductionConfig")
    DEBUG = False
    SQLALCHEMY_DATABASE_URI = 'mysql+pymysql://root:Boosal2014!!@sh-cdb-kzmpyjqw.sql.tencentcdb.com:63037/suishenwan'

    @classmethod
    def init_app(cls, app):
        Config.init_app(app)




config = {
    'development': DevelopmentConfig,
    'production': ProductionConfig,
    'default': DevelopmentConfig
}
