#!usr/bin/env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@time: 2021/04/27
@file: return_code.py
@function:
@modify:
"""
from flask import Response
from flask.json import dumps


class BASE_RESPONSE(Response):
    def __init__(self, data=None, error_code=0, error_message='Success'):
        if data:
            result = dumps(dict(data=data, error_code=error_code, error_message=error_message))
        else:
            result = dumps(dict(error_code=error_code, error_message=error_message))
        Response.__init__(self, result, mimetype='application/json')


SQL_ERROR = {
    "error_code": 9001,
    "error_message": "SQL execute error"
}

PARAMS_INVALID = {
    "error_code": 1001,
    "error_message": "params invalid"
}

DUPLICATE_RECORD = {
    "error_code": 1002,
    "error_message": "duplicate record"
}
