<?php
/**
 * Created by PhpStorm.
 * User: billy
 * Date: 25/04/2017
 * Time: 8:17 PM
 */

namespace App\Common\MQ;


use App\Common\Http;

class HttpConsumer
{
    //签名
    private static $signature = "Signature";
    //Consumer ID
    private static $consumerid = "ConsumerID";
    //访问码
    private static $aks = "AccessKey";

    /**
     * @var
     */
    private $url;

    /**
     * @var
     */
    private $ak;

    /**
     * @var
     */
    private $sk;

    /**
     * @var
     */
    private $cid;

    /**
     * @var
     */
    private $topic;

    /**
     * HttpConsumer constructor.
     * @param $url
     * @param $ak
     * @param $sk
     * @param $cid
     * @param $topic
     */
    public function __construct($url, $ak, $sk, $cid, $topic)
    {
        $this->url = $url;
        $this->ak = $ak;
        $this->sk = $sk;
        $this->cid = $cid;
        $this->topic = $topic;
    }

    protected function handleMessage()
    {
        return true;
    }

    public function consume()
    {
        $newline = "\n";

        while (true)
        {
            try
            {
                //构造时间戳
                $date = time()*1000;
                //签名字符串
                $signString = $this->topic.$newline.$this->cid.$newline.$date;
                //计算签名
                $sign = Util::calSignature($signString,$this->sk);
                //构造签名标记
                $signFlag = $this::$signature.":".$sign;
                //构造密钥标记
                $akFlag = $this::$aks.":".$this->ak;
                //标记
                $consumerFlag = $this::$consumerid.":".$this->cid;
                //构造HTTP请求发送内容类型标记
                $contentFlag = "Content-Type:text/html;charset=UTF-8";
                //构造HTTP头部信息
                $headers = array(
                    $signFlag,
                    $akFlag,
                    $consumerFlag,
                    $contentFlag,
                );
                //构造HTTP请求URL
                $getUrl = $this->url."/message/?topic=".$this->topic."&time=".$date."&num=32";

                $result = Http::GetWithHeader($headers, $getUrl);
                //解析HTTP应答信息
                $messages = json_decode($result,true);
                //如果应答信息中的没有包含任何的Topic信息,则直接跳过
                if (count($messages) ==0)
                {
                    continue;
                }
                //依次遍历每个Topic消息
                foreach ((array)$messages as $message)
                {
                    var_dump($message);

                    if ($this->handleMessage())
                    {
                        //构造删除Topic消息URL
                        $delUrl = $this->url."/message/?msgHandle=".$message['msgHandle']."&topic=".$this->topic."&time=".$date;
                        //签名字符串
                        $signString = $this->topic.$newline.$this->cid.$newline.$message['msgHandle'].$newline.$date;
                        //计算签名
                        $sign = Util::calSignature($signString,$this->sk);
                        //构造签名标记
                        $signFlag = $this::$signature.":".$sign;
                        //构造密钥标记
                        $akFlag = $this::$aks.":".$this->ak;
                        //构造消费者组标记
                        $consumerFlag = $this::$consumerid.":".$this->cid;
                        //构造HTTP请求头部信息
                        $delHeaders = array(
                            $signFlag,
                            $akFlag,
                            $consumerFlag,
                            $contentFlag,
                        );

                        $result = Http::DeleteWithHeader($delHeaders, $delUrl);
                    }
                }
            }
            catch (\Exception $e)
            {
                //打印异常信息
                echo $e->getMessage();
            }
        }
    }
}