<?php
/**
 * Created by PhpStorm.
 * User: billy
 * Date: 25/04/2017
 * Time: 7:58 PM
 */

namespace App\Common\MQ;

use App\Common\Http;

/**
 * Class HttpProducer
 * @package App\Common\MQ
 */
class HttpProducer
{
    //签名
    private static $signature = "Signature";

    //在MQ控制台创建的Producer ID
    private static $producerId = "ProducerID";

    //阿里云身份验证码
    private static $aks = "AccessKey";

    /**
     * @var
     */
    private $url;

    /**
     * @var
     */
    private $ak;

    /**
     * @var
     */
    private $sk;

    /**
     * @var
     */
    private $pid;

    /**
     * @var
     */
    private $topic;

    /**
     * @var
     */
    private $content;

    /**
     * @var
     */
    private $tag;

    /**
     * @var
     */
    private $key;


    /**
     * HttpProducer constructor.
     * @param $url
     * @param $ak
     * @param $sk
     * @param $pid
     * @param $topic
     * @param $content
     * @param $tag
     * @param $key
     */
    public function __construct($url, $ak, $sk, $pid, $topic, $content, $tag, $key)
    {
        $this->url = $url;
        $this->ak = $ak;
        $this->sk = $sk;
        $this->pid = $pid;
        $this->topic = $topic;
        $this->content = $content;
        $this->tag = $tag;
        $this->key = $key;
    }


    /**
     * @param array $headerParam
     * @param array $urlParam
     * @return mixed
     */
    public function produce($headerParam=array(), $urlParam=array())
    {
        $date = time()*1000;
        $newline = "\n";
        //POST请求url
        $postUrl = $this->url."/message/?topic=".$this->topic."&time=".$date."&tag=".$this->tag."&key=".$this->key;

        foreach ($urlParam as $key=>$value)
        {
            $postUrl.='&'.$key.'='.$value;
        }

        //签名字符串
        $signString = $this->topic.$newline.$this->pid.$newline.md5($this->content).$newline.$date;
        //计算签名
        $sign = Util::calSignature($signString,$this->sk);

        //构造签名标记
        $signFlag = $this::$signature.":".$sign;
        //构造密钥标记
        $akFlag = $this::$aks.":".$this->ak;
        //标记
        $producerFlag = $this::$producerId.":".$this->pid;
        //构造HTTP请求头部内容类型标记
        $contentFlag = "Content-Type:text/html;charset=UTF-8";
        //构造HTTP请求头部
        $headers = array(
            $signFlag,
            $akFlag,
            $producerFlag,
            $contentFlag,
        );

        foreach ($headerParam as $key=>$value)
        {
            array_push($headers, $key.':'.$value);
        }

        $result = Http::PostWithHeader($this->content, $headers, $postUrl);

        $result = json_decode($result, true);

        return $result;
    }


    /**
     * @param $delayTime
     * @return mixed
     */
    public function produceDelayMessage($delayTime)
    {
        $deliveryTime = time()*1000 + $delayTime * 1000;
        $param['startdelivertime'] = $deliveryTime;

        return $this->produce(array(), $param);
    }


    /**
     * @param $shardingKey
     * @return mixed
     */
    public function produceOrderMessage($shardingKey)
    {
        $param = array();
        $param['isOrder'] = true;
        $param['shardingKey'] = $shardingKey;

        return $this->produce($param);
    }
}