<?php
/**
 * Created by PhpStorm.
 * User: billy
 * Date: 10/02/2017
 * Time: 6:23 PM
 */

namespace App\Common;

use App\Common\Enums\LoginType;

/**
 * Class ThirdPartyLogin
 * @package App\Common
 */
class ThirdPartyLogin
{
    public static function verify($openId, $accessToken, $type)
    {
        if ($type == LoginType::QQ)
        {
            return self::qq_verify($openId, $accessToken);
        }
        else if($type == LoginType::WECHAT)
        {
            return self::wechat_verify($openId, $accessToken);
        }
    }


    private static function qq_verify($openId, $accessToken)
    {
        $target = "https://graph.qq.com/oauth2.0/me?access_token=".$accessToken;
        $result = Http::Get($target);

        if($result != null)
        {
            if (preg_match('/openid":"'.$openId.'"/', $result))
            {
                return true;
            }
        }

        return false;
    }

    private static function wechat_verify($openId, $accessToken)
    {
        $target = "https://api.weixin.qq.com/sns/auth?access_token=".$accessToken."&openid=".$openId;
        $result = Http::Get($target);

        if($result != null)
        {
            if (preg_match('/"errcode":0,/', $result))
            {
                return true;
            }
        }

        return false;
    }
}