<?php
/**
 * Created by PhpStorm.
 * User: machengjun
 * Date: 2018/3/22
 * Time: 下午3:26
 */

namespace App\Http\Controllers\Api\Business;

use App\Http\Controllers\Controller;
use App\Http\Requests\Business\Api\BusinessLoginRequest;
use App\Repositories\Business\BusinessRepository;
use App\Repositories\Business\MachineRepository;
use App\Repositories\Business\SpotRepository;
use App\Repositories\CustomerRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

/**
 * Class CustomerController
 * @package App\Http\Controllers\Api
 */
class MachineController extends Controller
{

    protected $business;
    protected $spot;
    protected $machine;

    public function __construct(BusinessRepository $business, SpotRepository $spot, MachineRepository $machine)
    {
        $this->business = $business;
        $this->spot = $spot;
        $this->machine = $machine;

    }


    public function getSpotMachine(Request $request)
    {
        Log::info("[businessLogin]params" . json_encode($request->all()));

        $spot_id = $request->get('spot_id');
        //验证指定景点权限
        $this->spot->spotPermission($request->get('user'), $spot_id);

        $machines_obj = $this->machine->getSpotMachineList($spot_id);

        $response['machine'] = $this->_formatSpotMachine($machines_obj);

        return $this->responseSuccess($response);
    }

    private function _formatSpotMachine($machines_obj)
    {
        $data = [];
        if ($machines_obj != null) {
            foreach ($machines_obj as $k => $v) {
                $data[$k]['id'] = $v->id;
                $data[$k]['mac_no'] = $v->mac_no;
            }
        }
        return $data;

    }


}