<?php

namespace App\Http\Controllers\Api\Business;

use App\Common\Enums\HtTab;
use App\Exceptions\Api\ApiException;
use App\Http\Controllers\LoginController;
use App\Modules\Enums\ErrorCode;
use App\Repositories\Business\GuideRepository;
use App\Repositories\Business\MachineRepository;
use App\Repositories\Business\ProductionRepository;
use App\Repositories\Business\RentRepository;
use App\Repositories\Business\ReportRepository;
use App\Repositories\Business\SpotRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;



class RentController extends LoginController
{

    protected $rent;
    protected $spot;


    public function __construct(RentRepository $rent, SpotRepository $spot)
    {

        $this->rent = $rent;
        $this->spot = $spot;

    }


    public function rentList(Request $request)
    {

        Log::info("[businessRentList] params:" . json_encode($request->all()));

        $spot_id = $this->spot->getToShowSpot($request->get('user'));

        $data = $request->only('page', 'limit');
        $data['page'] = isset($data['page']) ? $data['page'] : 0;
        $data['limit'] = isset($data['limit']) ? $data['limit'] : HtTab::DEFAULT_LIMIT;
        $search = $request->only('day', 'month', 'status', 'total');

        if ($spot_id == 14) {
            $rent_records_obj = $this->rent->getSpotAllStatusRentTest($spot_id, $data['page'], $data['limit'], $search);
        }else{
            $rent_records_obj = $this->rent->getSpotAllStatusRent($spot_id, $data['page'], $data['limit'], $search);    
        }
        

        $response['data'] = $this->_formatAllStatusRent($rent_records_obj, $spot_id);

        return $this->responseSuccess($response);

    }

    public function rentDetail(Request $request)
    {
        Log::info("[businessRentDetail] params:" . json_encode($request->all()));
        if (!$rent_no = $request->get('rent_no')) {
            throw new ApiException(ErrorCode::PARAM_ERROR, trans('api.error.param_error'));
        }
        $spot_id = $this->spot->getToShowSpot($request->get('user'));
        if ($spot_id == 14) {
            $rent_obj = $this->rent->getSpotRentDetailTest($rent_no, $spot_id);
        }else{
            $rent_obj = $this->rent->getSpotRentDetail($rent_no, $spot_id);    
        }
        
        $response['data'] = $this->_formatSpotRentDetail($rent_obj);
        return $this->responseSuccess($response);


    }

    private function _formatSpotRentDetail($rent_obj)
    {
        $data = [
            'spot_name' => $rent_obj->spot->spotname,
            'rent_price' => feeMes($rent_obj->free_time, $rent_obj->one_day_price),
            'deposit' => round($rent_obj->deposit / 100, 2),
            'is_return' => $rent_obj->is_over,
            'real_total' => round($rent_obj->real_total / 100, 2),
            'rent_start_time' => $rent_obj->pay_time,
            'rent_over_time' => $rent_obj->over_time,
            'mac_no' => $rent_obj->machine->mac_no,
            'rent_no' => $rent_obj->rent_no,
            'phone' => $rent_obj->customer->phone,
        ];

        return $data;

    }

    private function _formatAllStatusRent($rent_records_obj)
    {
        $data = [];
        if ($rent_records_obj != null) {
            foreach ($rent_records_obj as $k => $rent_record_obj) {
                $data[$k]['rent_no'] = $rent_record_obj->rent_no;
                $data[$k]['rent_time'] = $rent_record_obj->pay_time;
                $data[$k]['real_total'] = $rent_record_obj->real_total;
                $data[$k]['status'] = $rent_record_obj->is_over;
            }
        }
        return $data;
    }


}