<?php
/**
 * Created by PhpStorm.
 * User: machengjun
 * Date: 2018/2/12
 * Time: 上午11:41
 */

namespace App\Http\Controllers\Api\Customers;


use App\Exceptions\Api\ApiException;
use App\Http\Controllers\LoginController;
use App\Modules\Enums\ErrorCode;
use App\Modules\Models\CouponOrder\CouponOrder;
use App\Repositories\Customers\CouponRepository;
use App\Repositories\Customers\SMSRepository;
use Illuminate\Http\Request;
use App\Modules\Enums\SuccessCode;
use Illuminate\Support\Facades\Log;

/**
 * Class CouponController
 * @package App\Http\Controllers\Api
 */
class CouponController extends LoginController
{

    protected $sms;
    protected $coupon;


    public function __construct(SMSRepository $sms, CouponRepository $coupon)
    {
        parent::__construct();
        $this->sms = $sms;
        $this->coupon = $coupon;

    }


    public function checkPhone()
    {
        Log::info("[checkPhone]");
        $response['success_code'] = SuccessCode::PHONE_NOT_BINDING;
        $response['success_mes'] = trans('api.success.phone_not_binding');
        if ($this->user->phone) {
            $response['success_code'] = SuccessCode::PHONE_BINDING;
            $response['success_mes'] = trans('api.success.phone_binding');
            $response['phone'] = substr_replace($this->user->phone,'*****',3,5);

        }
        return $this->responseSuccess($response);

    }

    public function sendCode(Request $request)
    {

        Log::info("[sendCode] params:" . json_encode($request->all()));

        $phone = $request->get('phone');
        $this->sms->phoneSendCode($phone,92065,'灰兔智能');
        $response['mes'] = trans('api.success.send_code_success');
        return $this->responseSuccess($response);

    }

    function register(Request $request)
    {
        Log::info("[sendCode] params:" . json_encode($request->all()));

        $data = $request->only('phone', 'code');
        if ($this->user->phone) {
            throw new ApiException(ErrorCode::CUSTOMER_HAS_REGISTER, trans('api.error.customer_has_register'));
        }
        $res = $this->coupon->validate($data['phone'], $data['code']);
        $res = 3;
        switch ($res) {
            case 1:
                $response['success_code'] = SuccessCode::PHONE_VALIDATE_CODE_EXPIRE;
                $response['success_mes'] = trans('api.success.phone_validate_code_expire');
                return $this->responseSuccess($response);
            case 2:
                $response['success_code'] = SuccessCode::PHONE_VALIDATE_FAIL;
                $response['success_mes'] = trans('api.success.phone_validate_fail');
                return $this->responseSuccess($response);
            default:
                break;
        }
        $this->coupon->updatePhone($this->user, $data['phone']);
        // $response = $this->coupon->autoSend($this->user->id);
        $response['success_code'] = SuccessCode::BINDING_SUCCESS;
        $response['success_mes'] = trans('api.success.binding_success');
        return $this->responseSuccess($response);

    }

    function myRecord()
    {
        Log::info("[myRecord]");
        $record_obj = $this->coupon->myAllRecord($this->user->id);
        $res = $this->coupon->recordFormat($record_obj);
        return $this->responseSuccess($res);

    }

    /** 扫描优惠券->状态
     * @param Request $request
     * @return mixed
     * @throws ApiException
     */
    public function scanCouponView(Request $request)
    {
        Log::info("[scanCouponView] params:" . json_encode($request->all()));
        $data = $request->only('qrCode');//获取参数

        $res = $this->coupon->checkBinder($data['qrCode']); //优惠券的具体数据
        $response['coupon_data'] = '';
        if ($res->user_id) {//是否已绑定
            if ($res->user_id != $this->user->id) {//是否是绑定者
                $response['success_code'] = SuccessCode::COUPON_HAS_BINDING;//27
                $response['success_mes'] = trans('api.success.coupon_has_binding');
                $response['coupon_data'] = $this->coupon->doCouponTypeInfo($data['qrCode']) * 0.01;
            } else {
                $response['success_code'] = SuccessCode::COUPON_SELF_BINDING;//28
                $response['success_mes'] = trans('api.success.coupon_self_binding');
                $response['coupon_data'] = $this->coupon->doCouponInfo($data['qrCode']);
            }
        } else {
            //绑定页面
            $response['success_code'] = SuccessCode::COUPON_NOT_BINDING;//26
            $response['success_mes'] = trans('api.success.coupon_not_binding');
            $response['coupon_data'] = $res['bonus'] * 0.01;
        }

        return $this->responseSuccess($response);
    }

    /**
     * @param Request $request
     * @return mixed
     * @throws ApiException
     */
    public function couponBind(Request $request)
    {
        Log::info("[couponBind] params:" . json_encode($request->all()));

        $data = $request->only('qrCode', 'oid');//获取参数

        $resp = $this->coupon->doCouponBind($this->user->id, $data['qrCode'], $data['oid']);

        switch ($resp){
            case 1://绑定失败 正在绑定操作
                $response['success_code'] = SuccessCode::COUPON_IS_BINDING;//29
                $response['success_mes'] = trans('api.success.coupon_is_binding');
                break;
            case 2:// 绑定失败 已被他人绑定
                $response['success_code'] = SuccessCode::COUPON_HAS_OTHER_BINDING;//30
                $response['success_mes'] = trans('api.success.coupon_has_other_binding');
                break;
            case 3:// 绑定失败 您已绑定
                $response['success_code'] = SuccessCode::COUPON_SELF_BINDING;//28
                $response['success_mes'] = trans('api.success.coupon_self_binding');
                $response['coupon_data'] = $this->coupon->doCouponInfo($data['qrCode']);
                break;
            case 4:// 绑定成功
                $response['success_code'] = SuccessCode::COUPON_SELF_BINDING_SUCCESS;//31
                $response['success_mes'] = trans('api.success.coupon_self_binding_success');
                $response['coupon_data'] = $this->coupon->doCouponInfo($data['qrCode']);
                break;
            case 5:// 绑定失败
                $response['success_code'] = SuccessCode::COUPON_SELF_BINDING_FAIL;//32
                $response['success_mes'] = trans('api.success.coupon_self_binding_fail');
                break;
            default:
                break;
        }

        return $this->responseSuccess($response);
    }

    /**
     * @param Request $request
     * @return mixed
     * @throws ApiException
     */
    public function getCoupon(Request $request)
    {
        Log::info("[getCoupon] params:" . json_encode($request->all()));

        $data = $request->only('qrCode');//获取参数

        $res = $this->coupon->doGetCoupon($this->user->id, $data['qrCode']);
        switch ($res){
            case 1://领取失败 正在领取操作 请勿连续 请求
                $response['success_code'] = SuccessCode::COUPON_IS_GETTING;//33
                $response['success_mes'] = trans('api.success.coupon_is_getting');
                break;
            case 2:// 领取失败 您已领取过
                $response['success_code'] = SuccessCode::COUPON_HAS_GETTING;//34
                $response['success_mes'] = trans('api.success.coupon_has_getting');
                break;
            case 3:// 领取成功
                $response['success_code'] = SuccessCode::COUPON_GETTING_SUCCESS;//35
                $response['success_mes'] = trans('api.success.coupon_getting_success');
                break;
            case 4:// 领取失败 系统故障 稍后再试
                $response['success_code'] = SuccessCode::COUPON_GETTING_FAIL;//36
                $response['success_mes'] = trans('api.success.coupon_getting_fail');
                break;
            default:
                break;
        }

        return $this->responseSuccess($response);

    }

}