<?php

namespace App\Http\Controllers\Api\Customers;

use App\Common\Utils;
use App\Http\Requests\Feedback\Api\StoreFeedbackRequest;
use App\Http\Requests\Feedback\Api\TencentAuthRequest;
use App\Repositories\Customers\FeedbackRepository;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class FeedbackController extends Controller
{

    /**
     * @var FeedbackRepository
     */
    private $feedbacks;

    /**
     * FeedbackController constructor.
     * @param FeedbackRepository $feedbacks
     */
    public function __construct(FeedbackRepository $feedbacks)
    {
        $this->feedbacks = $feedbacks;
    }


    /**
     * Display a listing of the resource.
     * @param $request
     * @return \Illuminate\Http\Response
     */
    public function tencentUploadAuthorization(TencentAuthRequest $request)
    {
        // 获取个人 API 密钥 https://console.qcloud.com/capi
        $appId = config('constants.tencent.APP_ID');
        $bucket = config('constants.tencent.BUCKET');
        $secretId = config('constants.tencent.SECRET_ID');
        $secretKey = config('constants.tencent.SECRET_KEY');

        $filename = Utils::guid().'.'.$request->get('postfix');
        $pathname = '/'.$appId.'/'.$bucket.'/img/'.$filename;

        $now = time();
        $random = rand();
        $expired = time() + 300;
        $plainText = "a=$appId&b=$bucket&k=$secretId&e=$expired&t=$now&r=$random&f=$pathname";
        $bin = hash_hmac('SHA1', $plainText, $secretKey, true);
        $bin = $bin.$plainText;

        $signature = base64_encode($bin);

        return $this->responseSuccess(['auth' => $signature, 'filename' => $pathname]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @param StoreFeedbackRequest $request
     * @return \Illuminate\Http\Response
     */
    public function create(StoreFeedbackRequest $request)
    {
        //
        $customer_id = Auth::user()->id;
        $input = $request->all();
        $input['customer_id'] = $customer_id;
        $this->feedbacks->create($input);

        return $this->responseSuccess();
    }

    /**
     * @return mixed
     */
    public function getReplay()
    {
        $customer_id = Auth::user()->id;

        $datas = $this->feedbacks->getReplay($customer_id);
        foreach ($datas as $key => $data){

            if($data->status == 0){
                $data->status = '未处理';
            }else{
                $data->status = '已处理';
            }

            if($data->reply == null){
                $data->reply = '暂无回复';
            }

            $data->urls = explode(',', $data->urls);

        }

        $da['data'] = json_decode($datas, true);
        return $this->responseSuccess($da);
    }
}
