<?php

namespace App\Http\Controllers\Api\Customers;


use App\Common\Enums\HtTab;
use App\Http\Controllers\LoginController;
use App\Modules\Models\Machine\Machine;
use App\Repositories\Customers\MachineRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redis;

/**
 * Class MachineController
 * @package App\Http\Controllers\Api
 */
class MachineController extends LoginController
{
    /**
     * @var MachineRepository
     */

    protected $machine;

    /**
     * MachineController constructor.
     * @param MachineRepository $machine
     */

    public function __construct(MachineRepository $machine)
    {
        parent::__construct();
        $this->machine = $machine;
    }


    public function rentInfo(Request $request)
    {

        Log::info("[rentInfo]params" . json_encode($request->all()));
        $response = $this->machine->rentInfo($request->get('mac_no'));
        return $this->responseSuccess($response);
    }

    public function nearby(Request $request)
    {
        Log::info("[nearby]params" . json_encode($request->all()));
        $machines = $this->machine->nearby($request->get('lat'), $request->get('lng'));
        $response = $this->nearByDataformat($machines);
        return $this->responseSuccess($response);
    }


    public function nearByDataformat($machines)
    {
        $data = [];
        for ($i = 0; $i < count($machines); $i++) {
            $data[$machines[$i]['mac_no']]['hatch_number'] = $machines[$i]['hatch_number'];
            $data[$machines[$i]['mac_no']]['mac_no'] = $machines[$i]['mac_no'];
            $data[$machines[$i]['mac_no']]['one_day_price'] = $machines[$i]['one_day_price'];
            $data[$machines[$i]['mac_no']]['lng'] = $machines[$i]['lng'];
            $data[$machines[$i]['mac_no']]['lat'] = $machines[$i]['lat'];
            $data[$machines[$i]['mac_no']]['distance'] = floor($machines[$i]['distance']);
            $data[$machines[$i]['mac_no']]['available_number'] = $machines[$i]['available_number'];
            $data[$machines[$i]['mac_no']]['spot_name'] = $machines[$i]['spot']['spotname'];
            $data[$machines[$i]['mac_no']]['spot_open_time'] = $machines[$i]['spot']['time'];
            $data[$machines[$i]['mac_no']]['spot_close_time'] = $machines[$i]['spot']['overtime'];
            $data[$machines[$i]['mac_no']]['address'] = $machines[$i]['address'];

            $data[$machines[$i]['mac_no']]['list_img'] = $machines[$i]['spot']['wx_logo'];
            $data[$machines[$i]['mac_no']]['detail_img'] = HtTab::IMG_HEAD_URL . $machines[$i]['spot']['detail_img'];
            $data[$machines[$i]['mac_no']]['return_img'] = ($machines[$i]['spot'] && $machines[$i]['spot']['return_img']) ? HtTab::IMG_HEAD_URL . $machines[$i]['spot']['return_img'] : '';

        }
        return ['result_number' => count($machines), 'machine' => $data];
    }


}