<?php

namespace App\Http\Requests\Customer\Api;

use App\Common\RegExpPattern;

use App\Http\Requests\ApiBaseRequest;

/**
 * Class CustomerLoginViaSmsRequest.
 * @package App\Http\Requests\Customer
 */
class CustomerLoginViaSmsRequest extends ApiBaseRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'telephone'        => 'required|regex:'.RegExpPattern::REGEX_MOBILE,
            'sms'              => 'required',
        ];
    }
}
