<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/1/30
 * Time: 14:16
 */

namespace App\Modules\Models\Beacon\Traits\Attribute;


trait BeaconAttribute
{
    public function getInfoButtonAttribute()
    {
        return '<a href="' . route('admin.customer.info', $this, false) . '" class="btn btn-xs btn-info"><i class="fa fa-info-circle" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.general.crud.info') . '"></i></a> ';
    }

    /**
     * @return string
     */
    public function getEditButtonAttribute()
    {
        return '<a href="' . route('admin.beacon.edit', $this) . '" class="btn btn-xs btn-primary"><i class="fa fa-pencil" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.general.crud.edit') . '"></i></a> ';
    }

    /**
     * @return string
     */
    public function getStatusButtonAttribute()
    {
        switch ($this->status) {
            case 0:
                return '<a href="' . route('admin.beacon.mark', [
                        $this,
                        1
                    ]) . '" class="btn btn-xs btn-warning"><i class="fa fa-pause" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.backend.beacon.deactivate') . '"></i></a> ';


            case 1:

            return '<a href="' . route('admin.beacon.mark', [
                    $this,
                    0
                ]) . '" class="btn btn-xs btn-success"><i class="fa fa-play" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.backend.beacon.activate') . '"></i></a> ';

            default:
                return '';
            // No break
        }
    }

    /**
     * @return string
     */
    public function getChangePasswordButtonAttribute()
    {
        return '<a href="' . route('admin.customer.change-password', $this) . '" class="btn btn-xs btn-info"><i class="fa fa-refresh" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.backend.access.users.change_password') . '"></i></a> ';
    }

    /**
     * @return string
     */
    public function getConsumeOrderButtonAttribute()
    {
        return '<a href="' . route('admin.customer.consumeOrders', $this) . '" class="btn btn-xs btn-primary"><i class="fa fa-bars" data-toggle="tooltip" data-placement="top" title="' . trans('labels.backend.customer.consume_order') . '"></i></a> ';
    }
    /**
     * @return string
     */
    public function getDeleteButtonAttribute()
    {
        //Can't delete master admin role
        if ($this->id ) {
            return '<a href="'.route('admin.business.destroy', $this, false).'"
                data-method="delete"
                data-trans-button-cancel="'.trans('buttons.general.cancel').'"
                data-trans-button-confirm="'.trans('buttons.general.crud.delete').'"
                data-trans-title="'.trans('strings.backend.general.are_you_sure').'"
                class="btn btn-xs btn-danger"><i class="fa fa-times" data-toggle="tooltip" data-placement="top" title="'.trans('buttons.general.crud.delete').'"></i></a>';
        }

        return '';
    }

//    public function getStatusLabelAttribute()
//    {
//        if ($this->isActive()) {
//            return "<label class='label label-success'>".trans('labels.general.active').'</label>';
//        }
//
//        return "<label class='label label-danger'>".trans('labels.general.inactive').'</label>';
//    }

    /**
     * @return string
     */
    public function getActionButtonsAttribute()
    {
        return

            $this->edit_button .
            $this->status_button;
            
    }
}