<?php

namespace App\Modules\Models\CustomerTest;

use App\Modules\Models\CustomerTest\Traits\Attribute\CustomerTestAttribute;
use App\Modules\Models\CustomerTest\Traits\Relationship\CustomerTestRelationship;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Tymon\JWTAuth\Contracts\JWTSubject;

class CustomerTest extends Authenticatable implements JWTSubject
{
    use CustomerTestAttribute, CustomerTestRelationship;

    //
    protected $table = 'customers_test';

    //
    protected $fillable = ['mini_program_open_id', 'openid', 'unionid', 'platform', 'phone', 'deposit', 'gender', 'language', 'nick_name', 'avatar_url', 'status'];

    protected $hidden = [];

    public function getHeadImageAttribute($value)
    {
        if ($value == '' || strpos($value, 'http') === 0) {
            return $value;
        }

        return config('constants.qiniu.user_bucket_url') . $value;
    }

    public function getGenderAttribute($value)
    {
        return $value ? trans('common.gender.female') : trans('common.gender.male');
    }

    /**
     * Get the identifier that will be stored in the subject claim of the JWT.
     *
     * @return mixed
     */
    public function getJWTIdentifier()
    {
        return $this->id;
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [
            'type' => 'customer'
        ];
    }
}
