<?php

namespace App\Modules\Models\Feedback\Traits\Relationship;

use App\Modules\Models\Customer\Customer;
use App\Modules\Models\Feedback\FeedbackImage;

/**
 * Class FeedbackRelationship
 * @package App\Modules\Models\Feedback\Traits\Relationship
 */
trait FeedbackRelationship
{
    /**
     * @return mixed
     */

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    /**
     * @return mixed
     */
    public function images()
    {
        return $this->hasMany(FeedbackImage::class, 'feedback_id', 'id');
    }
}