<?php
/**
 * Created by PhpStorm.
 * User: machengjun
 * Date: 2018/2/3
 * Time: 下午8:38
 */
namespace App\Modules\Models\Share\Traits\Relationship;

use App\Modules\Models\Customer\Customer;
use App\Modules\Models\Explain\Explain;
use App\Modules\Models\Explain_info\Explain_info;
use App\Modules\Models\GuideRule\GuideRule;
use App\Modules\Models\Receive\Receive;
use App\Modules\Models\Spot\Spot;

/**
 * Class BaseCustomerRelationship
 * @package App\Modules\Models\Customer\Traits\Relationship
 */
trait ShareRelationship
{
    /**
     * Consume Order Relation
     *@return mixed
     */

    public function spot()
    {
        return $this->belongsTo(Spot::class,'spot_id','id');
    }

    public function guideRule()
    {
        return $this->belongsTo(GuideRule::class,'spot_id','spot_id');
    }

    public function explainInfo(){
        return $this->hasMany(Explain_info::class,'spot_id','spot_id');
    }
    public function explain(){
        return $this->hasMany(Explain::class,'spot_id','spot_id');
    }

    public function customer(){
        return $this->belongsToMany(Customer::class,'receive', 'share_id', 'customer_id');
    }


}