<?php
/**
 * Created by PhpStorm.
 * User: machengjun
 * Date: 2018/3/12
 * Time: 下午4:40
 */
namespace App\Modules\Models\SystemUsers;

use App\Modules\Models\SystemUsers\Traits\Relationship\SystemUsersRelationship;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Tymon\JWTAuth\Contracts\JWTSubject;


class SystemUsers extends Authenticatable implements JWTSubject
{

    use SystemUsersRelationship;
    //
    protected $table = 'system_users';

    protected $fillable = ['id', 'username','first_name','last_name','password','status','business_id','science_id','remember_token','created_at','updated_at','deleted_at'];

    protected $hidden = [];

    /**
     * Get the identifier that will be stored in the subject claim of the JWT.
     *
     * @return mixed
     */
    public function getJWTIdentifier()
    {
        return $this->id;
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [
            'type' => 'business'
        ];
    }


}
