<?php
/**
 * Created by PhpStorm.
 * User: billy
 * Date: 18/03/2017
 * Time: 9:46 AM
 */

namespace App\Modules\Onenet\Message;


/**
 * Class BaseMessage
 * @package App\Modules\Models\HeCloudMessage
 */
class BaseMessage
{

    /**
     * @var
     */
    private $msgType;

    /**
     * @var string
     */
    private $devId;

    /**
     * @var string
     */
    private $dataStream;

    /**
     * BaseMessage constructor.
     * @param $msgType
     * @param $dataStream
     * @param $devId
     */
    public function __construct($msgType, $dataStream = 0, $devId = '')
    {
        $this->msgType = $msgType;
        $this->dataStream = $dataStream;
        $this->devId = $devId;
    }

    /**
     * @param $msg
     * @param $index
     * @param $time_stanza
     * @return string
     */
    protected function handleTimeStanza($msg, $index, $time_stanza)
    {
        $timeStr = "";
        for ($j = 0;$j < $time_stanza; $j++)
        {
            $time = $msg[$index + $j];
            $timeStr .= strval($time);
            if ($j == 0 || $j == 1)
            {
                $timeStr .= "-";
            }
            else if ($j == 2)
            {
                $timeStr .= " ";
            }
            else if ($j == 3 || $j == 4)
            {
                $timeStr .= ":";
            }
        }

        return $timeStr;
    }

    /**
     * @return mixed
     */
    public function getMsgType()
    {
        return $this->msgType;
    }

    /**
     * @param mixed $msgType
     */
    public function setMsgType($msgType)
    {
        $this->msgType = $msgType;
    }

    /**
     * @return string
     */
    public function getDevId()
    {
        return $this->devId;
    }

    /**
     * @param string $devId
     */
    public function setDevId($devId)
    {
        $this->devId = $devId;
    }

    /**
     * @return string
     */
    public function getDataStream()
    {
        return $this->dataStream;
    }

    /**
     * @param $dataStream
     */
    public function setDataStream($dataStream)
    {
        $this->dataStream = $dataStream;
    }
}