<?php
/**
 * Created by PhpStorm.
 * User: billy
 * Date: 01/09/2017
 * Time: 5:30 PM
 */

namespace App\Modules\Onenet\Message;


/**
 * Class CommandMessage
 * @package App\Modules\Onenet\Message
 */
class CommandMessage extends Message
{
    /**
     * @var string
     */
    private $command;

    /**
     * @var array
     */
    private $param;

    /**
     * CommandMessage constructor.
     * @param $deviceId
     * @param $command
     * @param $param
     */
    public function __construct($deviceId, $command, $param=array())
    {
        parent::__construct($deviceId);
        $this->command = $command;
        $this->param = $param;
    }

    /**
     * @return string
     */
    public function getCommand()
    {
        return $this->command;
    }

    /**
     * @param string $command
     */
    public function setCommand($command)
    {
        $this->command = $command;
    }

    /**
     * pack message to send to onenet
     * @return string
     */
    public function pack()
    {
        $msg = array();
        //header
        array_push($msg, '{');
        //body
        array_push($msg, $this->command.join('', $this->param));
        //tail
        array_push($msg, '}');

        return join('', $msg);
    }

    /**
     * unpack
     * @param $value
     */
    public function unpack($value)
    {
        echo "unpack";
    }
}