<?php
/**
 * Created by PhpStorm.
 * User: billy
 * Date: 18/03/2017
 * Time: 9:46 AM
 */

namespace App\Modules\Onenet\Message;

use App\Modules\Onenet\Enum\DataStreams;
use App\Modules\Onenet\Message\ReceiveMessage\BatteryMessage;
use App\Modules\Onenet\Message\ReceiveMessage\ConnectMessage;
use App\Modules\Onenet\Message\ReceiveMessage\ReturnMessage;
use App\Modules\Onenet\Message\ReceiveMessage\SellStateMessage;
use App\Modules\Onenet\Message\ReceiveMessage\SigQtyMessage;
use App\Modules\Onenet\Message\ReceiveMessage\TakeOutMessage;
use App\Modules\Onenet\Message\ReceiveMessage\VersionMessage;


/**
 * Class BaseMessage
 * @package App\Modules\Models\HeCloudMessage
 */
class MessageKit
{
    /**
     * @param $input
     * @return BaseMessage
     */
    public function unpack($input)
    {
        $msg = null;

        $dev_id = isset($input['dev_id']) ? $input['dev_id'] : '';
        if (isset($input['type']))
        {
            switch ($input['type'])
            {
                case MsgType::CONNECT_TYPE:
                    $msg = new ConnectMessage($dev_id);
                    $msg->unpack($input['status']);
                    break;

                case MsgType::DATASTREAM_TYPE:
                    switch ($input['ds_id'])
                    {
                        case DataStreams::BATTERY:
                            $msg = new BatteryMessage($dev_id);
                            $msg->unpack($input['value']);
                            break;

                        case DataStreams::BATTERY_RETURN:
                            $msg = new ReturnMessage($dev_id);
                            $msg->unpack($input['value']);
                            break;

                        case DataStreams::TAKEOUT:
                            $msg = new TakeOutMessage($dev_id);
                            $msg->unpack($input['value']);
                            break;

                        case DataStreams::SIGQTY:
                            $msg = new SigQtyMessage($dev_id);
                            $msg->unpack($input['value']);
                            break;

                        case DataStreams::VERSION:
                            $msg = new VersionMessage($dev_id);
                            $msg->unpack($input['value']);
                            break;

                        case DataStreams::SELL_STATE:
                            $msg = new SellStateMessage($dev_id);
                            $msg->unpack($input['value']);
                            break;
                    }
                    break;
            }
        }
        else
        {
            $msg = new BaseMessage(MsgType::VERIFY_TYPE);
        }

        return $msg;
    }
}