<?php
/**
 * Created by PhpStorm.
 * User: billy
 * Date: 01/09/2017
 * Time: 5:30 PM
 */

namespace App\Modules\Onenet\Message\ReceiveMessage;

use App\Modules\Onenet\Message\MsgType;
use App\Modules\Onenet\Message\ReceiveMessage;


/**
 * Class ConnectMessage
 * @package App\Modules\Onenet\Message
 */

class ConnectMessage extends ReceiveMessage
{
    private $status;

    /**
     * CommandMessage constructor.
     * @param $deviceId
     */
    public function __construct($deviceId)
    {
        parent::__construct($deviceId, MsgType::CONNECT_TYPE, '');
    }

    /**
     * @return mixed
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param mixed $status
     */
    public function setStatus($status)
    {
        $this->status = $status;
    }


    public function unpack($value)
    {
        $this->setStatus($value);
    }
}