<?php
/**
 * Created by PhpStorm.
 * User: billy
 * Date: 18/03/2017
 * Time: 9:48 AM
 */

namespace App\Modules\Onenet\Message\ReceiveMessage;


use App\Modules\Onenet\Enum\DataStreams;
use Illuminate\Support\Facades\Log;

class ReturnMessage extends BatteryOperationMessage
{
    private $battery_life;

    private $battery_stanza = 3;

    /**
     * ReturnMessage constructor.
     * @param $deviceId
     */
    public function __construct($deviceId)
    {
        parent::__construct($deviceId, DataStreams::BATTERY_RETURN);
    }

    /**
     * @return mixed
     */
    public function getBatteryLife()
    {
        return $this->battery_life;
    }

    /**
     * @return int
     */
    public function getBatteryStanza()
    {
        return $this->battery_stanza;
    }


    protected function getStanzaLength()
    {
        return parent::getStanzaLength() + $this->getBatteryStanza(); // TODO: Change the autogenerated stub
    }


    public function unpack($msg)
    {
        if (strlen($msg) != $this->getStanzaLength() && strlen($msg) != parent::getStanzaLength())
        {
            Log::error("[unpack] stanza size incorrect! received size:".strlen($msg).", actual size:".$this->getStanzaLength());
            return;
        }

        $this->unpackInternal($msg);

        if (strlen($msg) == $this->getStanzaLength())
        {
            $this->battery_life = intval(substr($msg, parent::getStanzaLength(), $this->getBatteryStanza()));
        }
    }
}