<?php
/**
 * Created by PhpStorm.
 * User: billy
 * Date: 01/09/2017
 * Time: 5:30 PM
 */

namespace App\Modules\Onenet\Message\ReceiveMessage;

use App\Modules\Enums\ErrorCode;
use App\Exceptions\Api\ApiException;
use App\Modules\Onenet\Enum\DataStreams;
use App\Modules\Onenet\Message\MsgType;
use App\Modules\Onenet\Message\ReceiveMessage;


/**
 * Class SigQtyMessage
 * @package App\Modules\Onenet\Message
 */

class SigQtyMessage extends ReceiveMessage
{
    /**
     * @var
     */
    private $iccid;

    /**
     * CommandMessage constructor.
     * @param $deviceId
     */
    public function __construct($deviceId)
    {
        parent::__construct($deviceId,MsgType::DATASTREAM_TYPE, DataStreams::SIGQTY);
    }

    /**
     * @return mixed
     */
    public function getIccid()
    {
        return $this->iccid;
    }

    /**
     * @param mixed $iccid
     */
    public function setIccid($iccid)
    {
        $this->iccid = $iccid;
    }

    /**
     * @param $value
     */
    public function unpack($value)
    {
        $startPos = strpos($value, ':') + 1;
        $length = strpos($value, '|') - $startPos;
        $value = substr($value, $startPos, $length);

        $this->setIccid($value);
    }
}