<?php

namespace App\Modules\Repositories\Ota;

use App\Modules\Models\Ota\OtaVersion;
use App\Modules\Repositories\BaseRepository;

/**
 * Class BaseOtaVersionRepository
 * @package App\Modules\Repositories\Ota
 */
class BaseOtaVersionRepository extends BaseRepository
{
    /**
     * Associated Repository Model.
     */
    const MODEL = OtaVersion::class;

    /**
     * @return \Illuminate\Database\Eloquent\Collection|static[]
     */
    public function getLatest()
    {
        $versions = OtaVersion::all();

        $latest_version = null;
        $latest_version_array = array(0,0,0,0);
        foreach ($versions as $version)
        {
            $versionArray = explode('.', $version);
            for ($i = 0; $i < 4; $i++)
            {
                if (intval($versionArray[$i]) > intval($latest_version_array[$i]))
                {
                    $latest_version_array = $versionArray;
                    $latest_version = $version;
                    break;
                }
            }
        }

        return $latest_version;
    }
}
