<?php

namespace App\Providers;

use App\Modules\Models\Order\ConsumeOrder;
use Carbon\Carbon;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Auth;
use Tymon\JWTAuth\JWTGuard;

/**
 * Class AuthServiceProvider.
 */
class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the application.
     *
     * @var array
     */
    protected $policies = [
        //
    ];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerPolicies();

        //
        Auth::extend('sms', function($app, $name, array $config) {
            // Return an instance of Illuminate\Contracts\Auth\Guard...

            return new JWTGuard($app['tymon.jwt'],
                new CustomerUserProvider(config('auth.customer_model')),
                $app['request']);
        });

        Auth::extend('sms2', function($app, $name, array $config) {
            // Return an instance of Illuminate\Contracts\Auth\Guard...

            return new JWTGuard($app['tymon.jwt'],
                new BusinessUserProvider(config('auth.business_model')),
                $app['request']);
        });
    }
}
