<?php

namespace App\Repositories\Business;

use App\Exceptions\Api\ApiException;
use App\Modules\Enums\ErrorCode;
use App\Modules\Models\Business\Business;
use App\Modules\Models\Production\Production;
use App\Modules\Models\ProductionTest\ProductionTest;
use App\Modules\Models\Spot\Spot;
use App\Modules\Repositories\BaseRepository;


/**
 * Class SpotRepository
 * @package App\Repositories\Spot
 */
class ProductionRepository extends BaseRepository
{
    public function getNotReturnProduction($spot_id)
    {
        $where = [
            ['spot_id', '=', $spot_id,],
            ['is_out', '=', '1'],
            ['is_return', '=', 0]
        ];
        $not_return_number = Production::where($where)->count();
        return $not_return_number;
    }

    public function getNotReturnProductionTest($spot_id)
    {
        $where = [
            ['spot_id', '=', $spot_id,],
            ['is_out', '=', '1'],
            ['is_return', '=', 0]
        ];
        $not_return_number = ProductionTest::where($where)->count();
        return $not_return_number;
    }
}
