<?php
/**
 * Created by PhpStorm.
 * User: machengjun
 * Date: 2018/2/7
 * Time: 下午3:58
 */

namespace App\Repositories\Customers;

use App\Exceptions\Api\ApiException;
use App\Modules\Enums\ErrorCode;
use App\Modules\Models\Power\Power;
use App\Modules\Repositories\BaseRepository;
use Illuminate\Support\Facades\Log;


/**
 * Class EloquentHistoryRepository.
 */
class PowerRepository extends BaseRepository
{
    function makePowerStatusSaled($powers)
    {
        $update = [
            'status' => 3
        ];

        $powers_id = array_column($powers, 'id');
        try {
            Power::whereIn('id', $powers_id)->Update($update);
        } catch (Exception $e) {
            throw new ApiException(ErrorCode::DATABASE_ERROR, trans('api.error.database_error'));
        }

        return true;
    }

    function takeOutSuccess($power_no)
    {

        $where = [
            ['power_no', '=', $power_no],
//            ['status', '=', 3],
        ];
        $power_obj = Power::where($where)->whereIn('status', [2, 3])->first();
        if ($power_obj->status == 3) {
            $power_obj->status = 4;
        } elseif ($power_obj->status == 2) {
            $power_obj->status = 1;
        }
//        $power_obj->status = 4;
        $power_obj->machine_id = null;
        $power_obj->hatch_no = null;
        $power_obj->save();
        return $power_obj;

    }

    function setPowerStatus($machine_id,$hatch_no,$power_no,$has_power, $pType, $season){
        $power_obj = Power::where('power_no',$power_no)->first();
        if($power_obj == null){
            //库里不存在充电宝，自动入库
            $this->onenetAddPower($power_no,$machine_id,$hatch_no,$has_power, $pType, $season);
            return true;
        }
        $this->updatePowerStatus($power_obj,$machine_id,$hatch_no,$has_power, $pType, $season);
        return true;
    }

    function onenetAddPower($power_no,$machine_id,$hatch_no,$has_power, $pType, $season){
        $power_obj = new Power();
        $power_obj->power_no = $power_no;
        $power_obj->has_power = $has_power;
        $power_obj->status = 2;
        $power_obj->machine_id = $machine_id;
        $power_obj->hatch_no = $hatch_no;
        $power_obj->power_type = $pType;
        $power_obj->season = $season;
        $power_obj->save();
    }


    function updatePowerStatus($power_obj,$machine_id,$hatch_no,$has_power, $pType, $season)
    {
        if($power_obj->status == 1){
            $power_obj->status = 2;
        }
        $power_obj->has_power = $has_power;
        $power_obj->machine_id = $machine_id;
        $power_obj->hatch_no = $hatch_no;
        $power_obj->power_type = $pType;
        $power_obj->season = $season;
        $power_obj->save();
    }

    function doReturn($machine_obj,$power_no_init,$hatch_no,$has_power, $isT){
        $power_no = substr($power_no_init, 4);
        $where = [
            ['power_no', '=', $power_no],
//            ['status', '=', 4],
        ];
//        $power_obj = Power::where($where)->first();
        $power_obj = Power::where($where)->whereIn('status', [1, 4])->first();

        if($power_obj == null){
            throw new ApiException(ErrorCode::SALE_POWER_NOT_EXIST, trans('api.error.sale_power_not_exist'));
        }
        $on = true;
        if($power_obj->status == 1){
            $on = false;
            $power_obj->status = 2;
        }else{
            if($isT == 0){
                $power_obj->status = 1;
            }else{
                $power_obj->status = 2;
            }
        }
//        $power_obj->status = 2;
        // $pType1 = substr($power_no, 2, 2);//获取讲解器类型
        
	    $pType = substr($power_no_init, 2, 2);
        if($pType != 'E2'){
            $pType = hex2bin($pType);    
        }
        $season = $this->getSeason($pType);
        $power_obj->machine_id = $machine_obj->id;
        $power_obj->hatch_no = $hatch_no;
        $power_obj->has_power = $has_power;
        $power_obj->power_type = $pType;
        $power_obj->season = $season;
        $power_obj->save();
        if($on){
            return $power_obj;
        }else{
            return null;
        }
    }

    public function getInfo($hatch_no)
    {
        $where = [
          'hatch_no'=>$hatch_no
        ];

        $info = Power::where($where)->first();
        Log::info($info);
        if($info == null){
            throw new ApiException(ErrorCode::SALE_POWER_NOT_EXIST, trans('api.error.sale_power_not_exist'));
        }
        return $info;
    }

    public function getPowerInfo($hatch_no, $mac_no)
    {
        $where = [
            'hatch_no'=>$hatch_no,
            'machine_id'=>$mac_no
        ];

        $info = Power::where($where)->orderBy('status', 'desc')->first();
        Log::info($info);
        if($info == null){
            throw new ApiException(ErrorCode::SALE_POWER_NOT_EXIST, trans('api.error.sale_power_not_exist'));
        }
        return $info;
    }

    public function getSeason($pType)
    {
        $datas = [
                ['A', 'E', 'I', 'M'],
                ['B', 'F', 'J', 'N'],
                ['C', 'G', 'K', 'O'],
                ['D', 'H', 'L', 'P'],
        ];

        foreach ($datas as $k=>$dada){
            if(in_array($pType, $dada)){
                return $k + 1;
            }
        }
        return 0;
    }
}
