<?php
/**
 * Created by PhpStorm.
 * User: machengjun
 * Date: 2018/2/9
 * Time: 下午3:05
 */
namespace App\Repositories\Customers;
use App\Modules\Repositories\BaseRepository;


/**
 * Class EloquentHistoryRepository.
 */
class ProductionRepository extends BaseRepository
{
    function makeProductionRefund($production_obj){
        $production_obj->is_refund = 1;
        $production_obj->refund_no = $this->createRefoundNo();
        $production_obj->is_return = 1;
        $production_obj->refund_time = date('Y-m-d H:i:s');
        $production_obj->save();
        return  $production_obj->refund_no;
    }

    /**
     * 生成退款单号
     */
    function createRefoundNo()
    {
        return 'RF' . date('Ymd') . str_pad(mt_rand(1, 9999999999), 10, '0', STR_PAD_LEFT);
    }

}