<?php
/**
 * Created by PhpStorm.
 * User: machengjun
 * Date: 2018/2/4
 * Time: 下午5:14
 */

namespace App\Repositories\Customers;

use App\Common\Enums\HtTab;
use App\Exceptions\Api\ApiException;

use App\Modules\Enums\ErrorCode;
use App\Modules\Models\Share\Share;
use App\Modules\Repositories\BaseRepository;

class WeGuideUseRepository extends BaseRepository
{


    function shareSpotInfo($order_no)
    {
        $where = [
            ['order_no', '=', $order_no],
        ];
        $spot_info = Share::with(['spot', 'guideRule'])->where($where)->first();
        if ($spot_info == null) {
            throw new ApiException(ErrorCode::SHARE_NOT_ENOUGH, trans('api.error.share_not_enough'));
        }
        return $spot_info;
    }

    /**
     * @param $share_info
     * @param $language
     * @return mixed
     */

    function spot_explain($share_info, $language)
    {

        $infos = $share_info->explain()->with(['info' => function ($query) use ($language) {
            $query->where('language', '=', $language);
        }, 'beacon'])->get();
        $data = [];
        $i = 0;
        $list = [];
        foreach ($infos as $info) {
            if ($info->beacon != null) {
                foreach ($info->beacon as $beacon) {
                    $k = $beacon->major . $beacon->minor;
                    $data["$k"]['title'] = $info->info[0]['title'];
                    $data["$k"]['mp3'] = HtTab::AUDIO_HEAD_URL.$info->info[0]['audio_url'];
                    $data["$k"]['img'] = HtTab::IMG_HEAD_URL.$info->info[0]['img_url'];
                    $data["$k"]['content'] = $info->info[0]['describetion'];
                    $data["$k"]['rssi'] = $beacon['rssi'];
                    $data["$k"]['sd'] = $beacon['sd'];
                    $list[$i]['major_minor'] = $k;
                    $list[$i]['title'] = $info->info[0]['title'];
                    $i++;
                }
            }
        }


        return ['data' => $data,'list' => $list];
    }

    function getSpotInfo($spot_id)
    {
        $spot = Spot::where('id', $spot_id)->first();
        $data = [
            'spot_name' => $spot->spotname,
            'wx_logo' => $spot->spotname,

        ];

    }
}
