<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatRentTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('rent', function (Blueprint $table) {
            $table->increments('id');
            $table->char('rent_no', 19)->comment('租借单号');
            $table->unsignedTinyInteger('number')->comment('租借数量');
            $table->unsignedInteger('deposit')->comment('单个押金');
            $table->unsignedInteger('one_day_price')->comment('日单价');
            $table->unsignedInteger('free_time')->comment('免费时间');
            $table->unsignedInteger('machine_id')->comment('机柜id');
            $table->unsignedInteger('customer_id')->comment('用户id');
            $table->unsignedInteger('total')->default(0)->comment('应收金额');
            $table->unsignedInteger('real_total')->default(0)->comment('实收金额');
            $table->unsignedInteger('back_money')->default(0)->comment('退款金额');
            $table->unsignedTinyInteger('is_pay')->default(0)->comment('是否支付');
            $table->unsignedTinyInteger('rent_type')->default(1)->comment('租借类型1现场租借2预约');
            $table->timestamp('add_time')->comment('下单时间');
            $table->timestamp('pay_time')->nullable()->comment('支付时间');
            $table->unsignedTinyInteger('is_take')->default(0)->comment('是否取货');
            $table->timestamp('take_time')->nullable()->comment('开始发货时间');
            $table->unsignedTinyInteger('is_over')->default(0)->comment('是否完结');
            $table->unsignedTinyInteger('is_cancel')->default(0)->comment('是否取消交易');
            $table->string('refund_no')->nullable()->comment('退款单号');
            $table->unsignedInteger('spot_id')->comment('景点id');
            $table->unsignedInteger('business_id')->comment('商家id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('rent');
    }
}
