<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMessageImagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('message_image', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('m_id')->comment('留言id');
            $table->string('img_url')->comment('图片路径');
            $table->integer('size')->comment('图片大小');
            $table->integer('message_id')->comment('对应的留言id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('message_image');
    }
}
