<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSpotTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('spot', function (Blueprint $table) {
            $table->increments('id');
            $table->string('spotname')->comment('景点名');
            $table->integer('business_id')->comment('关联id');
            $table->string('main_title')->comment('主标题');
            $table->string('vic_title')->comment('副标题');
            $table->string('detail_img')->nullable()->comment('展示界面的图片');
            $table->string('wx_logo')->comment('微型头像');
            $table->string('go_url')->nullable()->comment('定制化界面');
            $table->string('page_id')->comment('微信id');
            $table->string('code')->comment('唯一值');
            $table->string('time')->comment('开始时间');
            $table->string('overtime')->comment('结束时间');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('spot');
    }
}
