<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGuideRulesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('guide_rule', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('spot_id')->comment('景点id');
            $table->unsignedInteger('guide_fee')->comment('微导览费用单位分');
            $table->string('title')->comment('标题');
            $table->text('description')->comment('微导览描述');
            $table->string('guide_img')->comment('微导览图片');
            $table->integer('level')->comment('星级');
            $table->unsignedInteger('own_time')->default(3)->comment('享受服务的时间');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('guide_rule');
    }
}
