<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatProductionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('production', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('rent_id')->comment('租借id');
            $table->unsignedTinyInteger('is_out')->default(0)->comment('是否取出');
            $table->unsignedInteger('power_id')->comment('讲解器id');
            $table->string('power_no')->comment('讲解器编号');
            $table->unsignedInteger('rent_machine_id')->comment('租的机柜id');
            $table->unsignedTinyInteger('rent_hatch_no')->comment('租的仓口');
            $table->unsignedTinyInteger('is_return')->default(0)->comment('是否归还');
            $table->unsignedInteger('return_machine_id')->nullable()->comment('还的机柜id');
            $table->unsignedTinyInteger('return_hatch_no')->nullable()->comment('还的仓口');
            $table->timestamp('return_time')->nullable()->comment('还的时间');
            $table->unsignedTinyInteger('is_refund')->default(0)->comment('是否退款');
            $table->string('refund_no')->nullable()->comment('退款单号');
            $table->timestamp('refund_time')->nullable()->comment('退款时间');
            $table->unsignedInteger('total')->nullable()->comment('消费金额');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('production');
    }
}
