<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBeaconTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('beacon', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('apply_id')->comment('申请id');
            $table->string('device_id')->comment('beacon的id');
            $table->integer('major')->comment('beacon的major');
            $table->integer('minor')->comment('beacon的minor');
            $table->integer('rssi')->comment('beacon的强度范围');
            $table->integer('sd')->comment('beacon的移动范围');
            $table->integer('explain_id')->nullable()->comment('讲解点的id');
            $table->integer('status')->comment('beacon的状态');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('beacon');
    }
}
