<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateExplainInfoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('explain_info', function (Blueprint $table) {
            $table->increments('id');
            $table->string('title')->nullable()->comment('讲解点英文标题');
            $table->integer('explain_id')->default(0)->comment('景点id');
            $table->string('img_url', 255)->nullable()->comment('讲解点图片地址');
            $table->string('img_size', 45)->nullable()->comment('讲解点图片大小');
            $table->text('describetion')->comment('讲解点内容');
            $table->string('audio_url', 255)->comment('讲解点音频地址');
            $table->integer('audio_size')->comment('讲解点音频大小');
            $table->string('language')->comment('语言');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('explain_info');
    }
}
