<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGuideRecordTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('guide_record', function (Blueprint $table) {
            $table->increments('id');
            $table->char('guide_no', 19)->comment('微导览充值');
            $table->integer('total')->unsigned()->comment('支付总金额');
            $table->integer('real_total')->unsigned()->comment('实际支付金额');
            $table->timestamp('add_time')->comment('下单时间');
            $table->timestamp('pay_time')->nullable()->comment('支付时间');
            $table->integer('own_time')->unsigned()->default(3)->comment('享受服务的时间');
            $table->integer('customer_id')->unsigned()->comment('用户id');
            $table->tinyInteger('is_pay')->unsigned()->default(0)->comment('是否支付');
            $table->integer('spot_id')->unsigned()->comment('景区id');
            $table->integer('business_id')->unsigned()->comment('商户id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('guide_record');
    }
}
