<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePowerTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('power', function (Blueprint $table) {
            $table->increments('id');
            $table->string('power_no')->comment('充电宝编号');
            $table->integer('has_power')->default(0)->unsigned()->comment('充电宝电量');
            $table->tinyInteger('status')->default(1)->unsigned()->comment('充电宝状态1在仓库2在机柜可用3在机柜占用4出货成功');
            $table->tinyInteger('is_miss')->default(0)->unsigned()->comment('是否丢失0未丢1丢失');
            $table->integer('machine_id')->nullable()->unsigned()->comment('机柜id');
            $table->tinyInteger('hatch_no')->nullable()->unsigned()->comment('机柜仓口号');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('power');
    }
}
