<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatShareTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('share', function (Blueprint $table) {
            $table->increments('id');
            $table->char('order_no',19)->comment('可以分享的单号');
            $table->Integer('order_id')->unsigned()->comment('微导览单和租借单id');
            $table->tinyInteger('type')->unsigned()->comment('订单的类型1讲解器租借交易2微导览交易');
            $table->Integer('spot_id')->unsigned()->comment('景点id');
            $table->Integer('business_id')->unsigned()->comment('商家id');
            $table->unsignedInteger('customer_id')->comment('用户id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('share');
    }
}
