<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCouponType extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('coupon_type', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('type')->comment(' 优惠券类型 1是折扣 2是满减' );
            $table->integer('discount')->nullable()->comment('优惠券折扣');
            $table->integer('auto_send')->nullable()->commit('手机进来默认领取的状态');
            $table->integer('schedule_time')->nullable()->commit('手机进来默认领取得过期时间天');
            $table->integer('discount_money')->nullable()->comment('优惠金额');
            $table->integer('reason')->nullable()->comment('满多少减多少优惠金额');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('coupon_type');
    }
}
